<?php
/**
 * Theme sanitizers
 *
 * @package Let's Review
 * @since 1.0.0
 */

function lets_review_sanitize_wp_kses( $data ) {

	return wp_kses( $data, array(
		'a' => array(
			'href'  => array(),
			'class'  => array(),
			'style'    => array(),
			'id'  => array(),
			'target'  => array(),
			'data-format' => array(),
			'rel' => array(),
			'class' => array(),
			'data-source' => array(),
			'data-type' => array(),
			'data-src' => array(),
			'title' => array(),
		),
		'span' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'p' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'h1' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'h2' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'h3' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'h4' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'h5' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'img' => array(
			'src'    => array(),
			'srcset' => array(),
			'alt'    => array(),
		),
		'div' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'svg' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
			'viewbox'    => array(),
			'focusable'    => array(),
			'xmlns'    => array(),
			'width'    => array(),
			'height'    => array(),
			'aria-hidden'     => array(),
            'aria-labelledby' => array(),
            'role'            => array(),
		),
		'path' => array(
			'class' => array(),
			'id'    => array(),
			'd'    => array(),
			'fill'    => array(),
			'cx'    => array(),
			'cy'    => array(),
			'rx'    => array(),
			'ry'    => array(),
			'r'    => array(),
			'c'    => array(),
			'transform'    => array(),
			'fill-rule'    => array(),
		),
		'ellipse' => array(
			'class' => array(),
			'id'    => array(),
			'd'    => array(),
			'fill'    => array(),
			'cx'    => array(),
			'cy'    => array(),
			'rx'    => array(),
			'ry'    => array(),
			'r'    => array(),
			'c'    => array(),
			'transform'    => array(),
			'fill-rule'    => array(),
		),
		'circle' => array(
			'class' => array(),
			'id'    => array(),
			'd'    => array(),
			'fill'    => array(),
			'cx'    => array(),
			'cy'    => array(),
			'rx'    => array(),
			'ry'    => array(),
			'r'    => array(),
			'c'    => array(),
			'transform'    => array(),
			'fill-rule'    => array(),
		),
		'g' => array(
			'class' => array(),
			'id'    => array(),
			'd'    => array(),
			'fill'    => array(),
			'cx'    => array(),
			'cy'    => array(),
			'rx'    => array(),
			'ry'    => array(),
			'r'    => array(),
			'c'    => array(),
			'transform'    => array(),
			'fill-rule'    => array(),
		),
		'i' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'u' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'ul' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'ol' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'li' => array(
			'class' => array(),
			'id'    => array(),
			'style'    => array(),
		),
		'br'     => array(),
		'b'     => array(
			'style'    => array(),
		),
		'em'     => array(
			'class' => array(),
			'style'    => array(),
		),
		'strong' => array(
			'class' => array(),
			'style'    => array(),
		),
		'italic' => array(
			'class' => array(),
			'style'    => array(),
		),
		'iframe'  => array(
			'class' => array(),
			'id'    => array(),
			'src'    => array(),
			'width'    => array(),
			'style'    => array(),
			'height'    => array(),
		),
	));
}

function lets_review_sanitize_titles( $data ) {

	return wp_kses( $data, array(
		'span' => array(
			'class' => array(),
			'style' => array(),
		),
		'h1' => array(
			'class' => array(),
			'style' => array(),
		),
		'h2' => array(
			'class' => array(),
			'style' => array(),
		),
		'h3' => array(
			'class' => array(),
			'style' => array(),
		),
		'h4' => array(
			'class' => array(),
			'style' => array(),
		),
		'div' => array(
			'class' => array(),
			'style'    => array(),
		),
		'i' => array(
			'class' => array(),
			'style' => array(),
		),
		'u' => array(
			'style' => array(),
		),
		'p' => array(
			'style' => array(),
			'class' => array(),
		),
		'a' => array(
			'href' => array(),
			'style' => array(),
			'target' => array(),
			'data-format' => array(),
			'class' => array(),
			'rel' => array(),
			'data-source' => array(),
			'data-type' => array(),
			'data-src' => array(),
		),
		'b'     => array(),
		'strong' => array(
			'style'    => array(),
		),
		'em' => array(
			'style'    => array(),
			'class' => array(),
		),
		'br'     => array(),
	));

}

/**
 * Sanitizer Commas
 *
 * @since  1.0.0
 */
function lets_review_sanitize_num_commas( $data ) {
	$data = filter_var( $data, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION | FILTER_FLAG_ALLOW_THOUSAND );
	return $data;
}

/**
 * Sanitizer Array
 *
 * @since  1.0.0
 */
function lets_review_sanitize_array( $array ) {

	if ( ! is_array( $array ) ) {
		return array();
	}

	foreach ( $array as $key => $value ) {

		if ( is_array( $value ) ) {
			$array[ $key ] = lets_review_sanitize_array( $value );
		} else {
			$array[ $key ] = esc_attr( $value );
		}
	}

	return $array;
}


/**
 * Sanitizer Builder
 *
 * @since  1.0.0
 */
function lets_review_sanitizer_fonts( $fonts ) {
	$output = array();
	foreach ( $fonts as $font ) {
		$output[] = esc_attr( $font->key );
	}
	return $output;
}

/**
 * Sanitizer Builder Filter
 *
 * @since  1.0.0
 */
function lets_review_sanitizer_builder_filter( $block ) {
	$output = '';
	if ( ! empty( $block->custom_content ) ) {
		$output .= PHP_EOL . $block->custom_content;
	}

	if ( ! empty( $block->small_print ) ) {
		$output .= PHP_EOL . '<small>' . esc_attr( $block->small_print ) . '</small>';
	}

	if ( ! empty( $block->ad_img ) ) {
		if ( ! empty( $block->title ) ) {
			$output .= PHP_EOL . '<small>' . esc_attr( $block->title ) . '</small>';
		}
		if ( ! empty( $block->ad_url ) ) {
			$output .= PHP_EOL . '<a href="' . esc_url( $block->ad_url ) . '">';
		}
		$output .= PHP_EOL . '<img src="' . esc_url( $block->ad_img ) . '">';
		if ( ! empty( $block->ad_url ) ) {
			$output .= PHP_EOL . '</a>';
		}
	}

	if ( ! empty( $block->img_bg ) ) {
		$output .= PHP_EOL . '<img src="' . esc_url( $block->img_bg ) . '">';
	}

	if ( ! empty( $block->button_text ) ) {
		if ( ! empty( $block->button_url ) ) {
			$output .= PHP_EOL . '<a href="' . esc_url( $block->button_url ) . '" class="button"';
			if ( ! empty( $block->button_color ) ) {
				$output .= 'style="background-color: ' . esc_attr( $block->button_color ) . ' ;"';
			}
			$output .= '>';
		}
		$output .= PHP_EOL . $block->button_text;
		if ( ! empty( $block->button_url ) ) {
			$output .= PHP_EOL . '</a>';
		}
	}

	return $output;
}

function lets_review_sanitizer_options( $data, $options ) {
	if ( in_array( $data, $options ) ) {
		return $data;
	} else {
		return esc_attr( $data );
	}
}

function lets_review_sanitizer_measurement_type( $data ) {
	$output = '';
	if ( 'px' == $data ) {
		$output = 'px';
	} elseif ( '%' == $data ) {
		$output = '%';
	} elseif ( 'em' == $data ) {
		$output = 'em';
	} elseif ( 'rem' == $data ) {
		$output = 'rem';
	} else {
		$output = esc_attr( $data );
	}
	return $output;
}


function lets_review_sanitizer_border_type( $data ) {
	$output = '';
	if ( 'solid' == $data ) {
		$output = 'solid';
	} elseif ( 'dashed' == $data ) {
		$output = 'dashed';
	} elseif ( 'dotted' == $data ) {
		$output = 'dotted';
	} else {
		$output = esc_attr( $data );
	}
	return $output;
}
